/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.formatter.nodes;

import com.aptana.editor.html.formatter.HTMLFormatterNodeBuilder;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.FormatterBlockWithBeginEndNode;
import com.aptana.formatter.nodes.IFormatterTextNode;
import com.aptana.parsing.ast.IParseNode;
import java.util.Set;

public class FormatterDefaultElementNode
extends FormatterBlockWithBeginEndNode {
    private String element;
    private IParseNode[] children;

    public FormatterDefaultElementNode(IFormatterDocument document, String element, IParseNode[] children) {
        super(document);
        this.element = element;
        this.children = children;
    }

    protected boolean isIndenting() {
        Set set = this.getDocument().getSet("html.formatter.indent.excluded");
        return !set.contains(this.element);
    }

    protected boolean isAddingBeginNewLine() {
        if (this.getDocument().getBoolean("html.formatter.newline.exclusion.in.empty.tag") && this.isEmptyContent()) {
            return false;
        }
        Set set = this.getDocument().getSet("html.formatter.newline.excluded");
        if (set.contains(this.element)) {
            return false;
        }
        return !this.shouldPreventNewLine();
    }

    protected boolean isAddingEndNewLine() {
        if (!this.isAddingBeginNewLine()) {
            return false;
        }
        if (this.getDocument().getBoolean("html.formatter.newline.exclusion.in.empty.tag") && this.isEmptyContent()) {
            return false;
        }
        Set set = this.getDocument().getSet("html.formatter.newline.excluded");
        if (this.children == null || this.children.length == 0) {
            return !set.contains(this.element);
        }
        IParseNode child = this.children[this.children.length - 1];
        return !set.contains(this.element) || !set.contains(child.getNameNode().getName()) || !HTMLFormatterNodeBuilder.VOID_ELEMENTS.contains(child.getNameNode().getName());
    }

    protected int getBlankLinesAfter(IFormatterContext context) {
        int linesAfter = this.getInt("html.formatter.line.after.element");
        if (linesAfter == 0) {
            return -1;
        }
        return linesAfter;
    }

    private boolean shouldPreventNewLine() {
        if (this.children != null && this.children.length > 0 && HTMLFormatterNodeBuilder.SPACE_SENSITIVE_ELEMENTS.contains(this.element)) {
            return !Character.isWhitespace(this.getDocument().charAt(this.children[0].getStartingOffset()));
        }
        return false;
    }

    private boolean isEmptyContent() {
        IFormatterTextNode contentNode;
        String text;
        int bodyElementsCount = this.getBody().size();
        if (bodyElementsCount == 0) {
            return true;
        }
        return bodyElementsCount == 1 && this.getBody().get(0) instanceof IFormatterTextNode && (text = (contentNode = (IFormatterTextNode)this.getBody().get(0)).getText()).trim().length() == 0;
    }
}

